﻿var servers = {
    context: $(".v-servers"),
    datatable: null,
    selectedServerId: 0,
    refreshDataTable: function () {
        licenses.datatable.a4datatable("refresh");
    },
    initializeTreeView: function () {
        this.treeview = $(".h-serversList", this.context).a4listview({
            ajaxAction: a4.getAction("GetServers", "System", "Settings"),
            ajaxParams: { },
            expanded: true,
            displaySearchBox: false,
            altValueField: $("#ServerId"),
            selectNode: function (event, data) {

                servers.selectedServerId = data.node.Id;

                if (servers.datatable) {

                    servers.datatable.a4datatable("option", "ajaxParams", { "serverId": data.node.Id });
                    servers.datatable.a4datatable("refresh", true);
                }
                else
                {
                    servers.initializeDataTable();
                }
            }
        });
    },
    initializeDataTable: function () {
        this.datatable = $(".v-serverProperties-table", servers.context).a4datatable({
            //title: resources.InstalledLicenses,
            ajaxAction: a4.getAction("GetServerParameters", "System", "Settings"),
            ajaxParams: { "serverId": servers.selectedServerId },
            columns: [
                { "Name": "Name", "Title": resources.Parameter },
                { "Name": "Value", "Title": resources.Value }
            ],
            contextMenuItems: [],
            contextMenuClick: function (event, data) { },
            displayColumnSelector: false
        });
    },
    bindEvents: function () {
    }
}

$(document).ready(function () {
    if (servers.context.length > 0) {
        servers.initializeTreeView();
        servers.bindEvents();
    }
});


